unit MainAVCUSB;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ImgList, ExtCtrls, XPMan, Menus, CoolTrayIcon, ComCtrls,
  Buttons, USBTread, Mask, Math, Registry ;

type
  TForm1 = class(TForm)
    AVC_LAN: TCoolTrayIcon;
    PopupMenu1: TPopupMenu;
    N1: TMenuItem;
    XPManifest1: TXPManifest;
    N3: TMenuItem;
    Timer1: TTimer;
    ImageList1: TImageList;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    TabSheet3: TTabSheet;
    Button1: TButton;
    Button2: TButton;
    ComboBox1: TComboBox;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label9: TLabel;
    Button3: TButton;
    Label10: TLabel;
    CheckBox7: TCheckBox;
    ScrollBar1: TScrollBar;
    Label8: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Timer2: TTimer;
    Button4: TButton;
    Label13: TLabel;
    Label14: TLabel;
    TabSheet4: TTabSheet;
    CheckBox8: TCheckBox;
    CheckBox9: TCheckBox;
    CheckBox10: TCheckBox;
    CheckBox11: TCheckBox;
    Edit7: TEdit;
    Edit8: TEdit;
    Edit9: TEdit;
    Edit10: TEdit;
    Button5: TButton;
    Button6: TButton;
    Timer3: TTimer;
    Label16: TLabel;

    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    function ShiftStat(Shift: TShiftState):byte ;
    function StatToStr(Stat:byte):string ;
    procedure  LoadSetting(Key: String);
    procedure SaveSetting(Key: String);
    procedure ThreadMessage();
    procedure N1Click(Sender: TObject);

    procedure AVC_LANStartup(Sender: TObject; var ShowMainForm: Boolean);
//    procedure KeyboardEvent(VKey, VKey1: Byte);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Beep(N:string);
    procedure AdjustTouch();
    procedure N3Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);


    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure CheckBox5Click(Sender: TObject);
    procedure CheckBox6Click(Sender: TObject);
    procedure ScrollBar1Change(Sender: TObject);
    procedure CheckBox7Click(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure CheckBox8Click(Sender: TObject);
    procedure CheckBox9Click(Sender: TObject);
    procedure CheckBox10Click(Sender: TObject);
    procedure CheckBox11Click(Sender: TObject);
    procedure Timer3Timer(Sender: TObject);
  private
    USBtr:USBThread;
    TouchCount: byte;
    XTouch,YTouch,XTouch1,YTouch1 : integer;
    procedure KeyboardEvent(VKey, VKey1: Byte);
    procedure KeyboardEventDown(VKey, VKey1: Byte);
    procedure KeyboardEventUp();

    procedure WMCopyData(var M: TMessage);message WM_COPYDATA;
    procedure WM_CopyDataTX(Leen:byte);
    Function VkeyToStr(key : word):string;
  protected
    procedure WndProc(var Message: TMessage); override;

    { Private declarations }
  public
        USBThreadFlag : bool;
        MsFlag   : bool;
        mapStat, destStat, menuStat, maintStat, calendStat, langStat: byte;
        mapVkey, destVkey, menuVkey, maintVkey, calendVkey, langVkey: byte;
        FFStat, RRStat, FSStat, RSStat : byte;
        FFVkey, RRVkey, FSVkey, RSVkey : byte;
        mapEn, destEn, menuEn, maintEn, calendEn, langEn : boolean;
        FFEn, RREn, FSEn, RSEn : boolean;
        FSPress, RSPress : boolean;
       //  Vers : string;
        XRez,YRez:real;
        XError,YError:integer;
        MonitorCount : integer ;
        RbuttonEna : boolean;
        //Aux_RGB_Ena : boolean;
        RBTime : integer;
        PtOld: TPoint;
        RIGHTDOWN : boolean;
        EnaDone : boolean;
    { Pub lic declarations }
  end;
  const



   vkControl:byte = 1;
   vkShift:byte = 2;
   vkMenu:byte = 4;


var
  Form1: TForm1;

implementation

uses  RegMsg,  SetScr;
{$R *.dfm}
const
  SetupKey = 'Software\Homeword\AVC USB Adapter';
  Vers = '3.07a';
var
  InData : string ;
  OutData : string ;

  RegisterDone : boolean = false;
  HandleClient : hWnd;
  ClosedEnable : boolean = false;

procedure TForm1.WndProc(var Message: TMessage);
begin
  if Message.Msg = WM_AVC_Request then
    begin
      HandleClient := Message.wParam ;
      PostMessage(HandleClient, WM_AVC_Answer, Handle,0);
      RegisterDone := true;
 //     StatusBar1.Panels[0].Text := ' ' ;

    end
    else inherited WndProc(Message);
end;

Procedure TForm1.WMCopyData(var M: TMessage);
{ Handler for WM_COPYDATA message }
begin
  { Check wParam to ensure we know WHO sent us the WM_COPYDATA message }
   if M.wParam = HandleClient then
    begin
     InData :=  PChar(PCopyDataStruct(M.lParam)^.lpData);
     if Copy(InData,3,2) = 'F0' then
      begin
       Beep('$'+ Copy(InData,5,2));
      end;

     if Copy(InData,3,2) = 'B0' then
      begin
        if Copy(InData,5,2) = '00' then
          begin
            USBtr.USBON := false;

          end;
        if Copy(InData,5,2) = '01' then
          begin
            USBtr.USBON := true;
          end;
      end;

     if Copy(InData,3,2) = 'B1' then
      begin
        if USBtr.AdaptEnable then
          begin
            USBtr.LenTX := 2;
            USBtr.PacketDataTX[0]:= $F5;
            USBtr.PacketDataTX[1]:= $01;
            USBtr.TXFlag := true;
          end;
      end;
   end;
end;


procedure TForm1.WM_CopyDataTX(Leen:byte);
var
   DataBuffer: TCopyDataStruct;
begin
      with DataBuffer do
        begin
          { Fill dwData with registered message as safety check }
          dwData := 0;
          cbData := Leen * 2;
          lpData := PChar(OutData);
        end;
      SendMessage(HandleClient, WM_COPYDATA, Handle, Longint(@DataBuffer));
end;




procedure TForm1.AdjustTouch();
begin
  case  TouchCount  of
  0:
      begin
        XTouch := USBtr.PacketDataRX[1];   //    
        YTouch := USBtr.PacketDataRX[2] xor $FF;  //Y    
        // ,      ,     ,

        Form4.DrawXX(Form4.XDispl,Form4.YDispl,5,80,clWhite);   // 
        Form4.DrawXX(Form4.XDispl1,Form4.YDispl1,5,80,clRed);    // 
        TouchCount := 1;
      end ;

  1:
      begin
        Form4.DrawXX(Form4.XDispl1,Form4.YDispl1,5,80,clWhite);   // 
        Form4.Close;
        XTouch1 := USBtr.PacketDataRX[1];
        YTouch1 := USBtr.PacketDataRX[2] xor $FF;
        XRez := (Form4.XDispl1 - Form4.XDispl) / (XTouch1-XTouch);
        YRez := (Form4.YDispl1 - Form4.YDispl) / (YTouch1-YTouch);
        XError := Ceil( XTouch*XRez - Form4.XDispl);
        YError := Ceil( YTouch*YRez -Form4.YDispl );
        TouchCount := 0;
        SaveSetting(SetupKey);
      end ;

  end;
end;



procedure TForm1.FormCreate(Sender: TObject);
var
  hMutex : THandle;
begin

   hMutex := CreateMutex(NIL, true , 'AVC USB Interface');
  if GetLastError = ERROR_ALREADY_EXISTS then
  begin
    CloseHandle(hMutex);
    Application.Terminate;
  end;
    AVC_LAN.IconIndex := 2;
    Label7.Caption := Vers;


    USBtr:= USBThread.Create(true);
    USBtr.Priority := tpLower;
    USBtr.FreeOnTerminate := true;
    USBtr.Resume;
    USBtr.USBON := true;
 //    sLabelFX1.Caption := Vers;

//    AdjustResolution(Self);
    TouchCount := 0;
    MonitorCount := 0;
    LoadSetting(SetupKey);
   if Screen.MonitorCount > 1 then
    begin
      ComboBox1.Enabled := true 
    end
    else
    begin
    ComboBox1.Enabled := false;
    MonitorCount := 0;
    end;
   ComboBox1.ItemIndex := MonitorCount;


  CheckBox1.Checked := mapEn;
  CheckBox2.Checked := destEn;
  CheckBox3.Checked := menuEn;
  CheckBox4.Checked := maintEn;
  CheckBox5.Checked := calendEn;
  CheckBox6.Checked := langEn;


  CheckBox8.Checked := FFEn;
  CheckBox9.Checked := RREn;
  CheckBox10.Checked := FSEn;
  CheckBox11.Checked := RSEn;

//  CheckBox12.Checked := Aux_RGB_Ena;
  CheckBox7.Checked := RbuttonEna;
  Label8.Enabled := CheckBox7.Checked;
  Label11.Enabled := CheckBox7.Checked;
  Label12.Enabled := CheckBox7.Checked;
  Timer2.Interval := RBTime*1000;
  ScrollBar1.Position := RBTime;
  ScrollBar1.Enabled := CheckBox7.Checked;



  Edit1.Text := StatToStr(mapStat)+' '+ VkeyToStr(mapVkey);
  Edit2.Text := StatToStr(destStat)+' '+ VkeyToStr(destVkey);
  Edit3.Text := StatToStr(menuStat)+' '+ VkeyToStr(menuVkey);
  Edit4.Text := StatToStr(maintStat)+' '+ VkeyToStr(maintVkey);
  Edit5.Text := StatToStr(calendStat)+' '+ VkeyToStr(calendVkey);
  Edit6.Text := StatToStr(langStat)+' '+ VkeyToStr(langVkey);

  Edit7.Text := StatToStr(FFStat)+' '+ VkeyToStr(FFVkey);
  Edit8.Text := StatToStr(RRStat)+' '+ VkeyToStr(RRVkey);
  Edit9.Text := StatToStr(FSStat)+' '+ VkeyToStr(FSVkey);
  Edit10.Text := StatToStr(RSStat)+' '+ VkeyToStr(RSVkey);



  Edit1.Enabled := CheckBox1.Checked ;
  Edit2.Enabled := CheckBox2.Checked ;
  Edit3.Enabled := CheckBox3.Checked ;
  Edit4.Enabled := CheckBox4.Checked ;
  Edit5.Enabled := CheckBox5.Checked ;
  Edit6.Enabled := CheckBox6.Checked ;

  Edit7.Enabled := CheckBox8.Checked ;
  Edit8.Enabled := CheckBox9.Checked ;
  Edit9.Enabled := CheckBox10.Checked ;
  Edit10.Enabled := CheckBox11.Checked ;


 end;


procedure TForm1.FormDestroy(Sender: TObject);
begin
   USBtr.Terminate;
end;

function TForm1.ShiftStat(Shift: TShiftState):byte ;
begin
      result := 0;
      if ssCtrl in Shift then result := result + vkControl;
      if ssShift in Shift then result := result + vkShift;
      if ssAlt in Shift then result := result + vkMenu ;

end;

function TForm1.StatToStr(Stat:byte):string ;
begin
     result := '';
      if Stat and vkControl = vkControl then Result := result + 'CTRL+';
      if Stat and vkShift = vkShift   then Result := result + 'SHIFT+';
      if Stat and vkMenu = vkMenu   then Result := result + 'ALT+';


end;


procedure TForm1.LoadSetting(Key: String);
var
  Reg: TRegIniFile;
begin
  Reg := TRegIniFile.Create(Key);
  mapEn := Reg.ReadBool('','MAP_Enable',false);
  destEn := Reg.ReadBool('','DEST_Enable',false);
  menuEn := Reg.ReadBool('','MENU_Enable',false);
  maintEn := Reg.ReadBool('','MAINTENANCE_Enable',false);
  calendEn := Reg.ReadBool('','CALENDAR_Enable',false);
  langEn := Reg.ReadBool('','LANGUAGE_Enable',false);

  FFEn := Reg.ReadBool('','FF_Enable',false);
  RREn := Reg.ReadBool('','RR_Enable',false);
  FSEn := Reg.ReadBool('','FS_Enable',false);
  RSEn := Reg.ReadBool('','RS_Enable',false);


  mapVkey := Reg.ReadInteger('','mapKey',0);
  destVkey := Reg.ReadInteger('','destKey',0);
  menuVkey := Reg.ReadInteger('','menuKey',0);
  maintVkey := Reg.ReadInteger('','maintKey',0);
  calendVkey := Reg.ReadInteger('','calendKey',0);
  langVkey := Reg.ReadInteger('','langKey',0);

  FFVkey := Reg.ReadInteger('','FFKey',0);
  RRVkey := Reg.ReadInteger('','RRKey',0);
  FSVkey := Reg.ReadInteger('','FSKey',0);
  RSVkey := Reg.ReadInteger('','RSKey',0);


  mapStat := Reg.ReadInteger('','mapStat',0);
  destStat := Reg.ReadInteger('','destStat',0);
  menuStat := Reg.ReadInteger('','menuStat',0);
  maintStat := Reg.ReadInteger('','maintStat',0);
  calendStat := Reg.ReadInteger('','calendStat',0);
  langStat := Reg.ReadInteger('','langStat',0);

  FFStat := Reg.ReadInteger('','FFStat',0);
  RRStat := Reg.ReadInteger('','RRStat',0);
  FSStat := Reg.ReadInteger('','FSStat',0);
  RSStat := Reg.ReadInteger('','RSStat',0);


  XError := Reg.ReadInteger('','XError',0);
  YError := Reg.ReadInteger('','YError',0);
  XRez := StrToCurr(Reg.ReadString('','XRez','0'));
  YRez := StrToCurr(Reg.ReadString('','YRez','0'));
  MonitorCount := Reg.ReadInteger('','MCount',0);
  RbuttonEna := Reg.ReadBool('','RB_Enable',false);
  RBTime := Reg.ReadInteger('','RBTime',1);
//  Aux_RGB_Ena := Reg.ReadBool('','RGB_Ena',false);
  Reg.Free;
end;


procedure TForm1.SaveSetting(Key: String);
var
  Reg: TRegIniFile;
begin
  Reg := TRegIniFile.Create(Key);
  Reg.WriteBool( '','MAP_Enable',mapEn);
  Reg.WriteBool( '','DEST_Enable',destEn);
  Reg.WriteBool( '','MENU_Enable',menuEn);
  Reg.WriteBool( '','MAINTENANCE_Enable',maintEn);
  Reg.WriteBool( '','CALENDAR_Enable',calendEn);
  Reg.WriteBool( '','LANGUAGE_Enable',langEn);

  Reg.WriteBool( '','FF_Enable',FFEn);
  Reg.WriteBool( '','RR_Enable',RREn);
  Reg.WriteBool( '','FS_Enable',FSEn);
  Reg.WriteBool( '','RS_Enable',RSEn);



  Reg.WriteInteger('','mapKey',mapVkey);
  Reg.WriteInteger('','destKey',destVkey);
  Reg.WriteInteger('','menuKey',menuVkey);
  Reg.WriteInteger('','maintKey',maintVkey);
  Reg.WriteInteger('','calendKey',calendVkey);
  Reg.WriteInteger('','langKey',langVkey);

  Reg.WriteInteger('','FFKey',FFVkey);
  Reg.WriteInteger('','RRKey',RRVkey);
  Reg.WriteInteger('','FSKey',FSVkey);
  Reg.WriteInteger('','RSKey',RSVkey);


  Reg.WriteInteger('','mapStat',mapStat);
  Reg.WriteInteger('','destStat',destStat);
  Reg.WriteInteger('','menuStat',menuStat);
  Reg.WriteInteger('','maintStat',maintStat);
  Reg.WriteInteger('','calendStat',calendStat);
  Reg.WriteInteger('','langStat',langStat);

  Reg.WriteInteger('','FFStat',FFStat);
  Reg.WriteInteger('','RRStat',RRStat);
  Reg.WriteInteger('','FSStat',FSStat);
  Reg.WriteInteger('','RSStat',RSStat);

  Reg.WriteInteger('','XError',XError);
  Reg.WriteInteger('','YError',YError);
  Reg.WriteString('','XRez',floattostr(XRez));
  Reg.WriteString('','YRez',floattostr(YRez));

  Reg.WriteInteger('','MCount',MonitorCount);
  Reg.WriteBool( '','RB_Enable',RbuttonEna);
  Reg.WriteInteger('','RBTime',RBTime);
//  Reg.WriteBool( '','RGB_Ena',Aux_RGB_Ena);
  Reg.Free;
end;






procedure TForm1.ThreadMessage();
var
  Pt: TPoint;
begin
  Application.ProcessMessages;

  if USBtr.PacketDataRX[0]=$A0 then
   begin

    if   (Form4.SetTouch) and (not MsFlag) then
      begin
        AdjustTouch();
        Beep('$01');
        MsFlag := true;
      end
      else
      begin
        if (USBtr.PacketDataRX[1]=0) and (USBtr.PacketDataRX[2]=0) then
          begin
            {    }
            if not RIGHTDOWN then Mouse_Event(MOUSEEVENTF_LEFTUP, 0, 0, 0, 0);

            Timer2.Enabled := false;
            RIGHTDOWN := false;
            MsFlag := false;
          end
          else
          begin
            {  }
            Pt.x := round(USBtr.PacketDataRX[1]*XRez - XError)+
              Screen.Monitors[MonitorCount].Left;
            Pt.y := round((USBtr.PacketDataRX[2] xor $FF )*YRez - YError)+
              Screen.Monitors[MonitorCount].Top;

            SetCursorPos(Pt.x, Pt.y);

            if ((PtOld.X < (Pt.X+40))and(PtOld.X > (Pt.X-40)))and
            ((PtOld.Y < (Pt.Y+40))and(PtOld.Y > (Pt.Y-40))) then
              begin
               if RbuttonEna then Timer2.Enabled := true;
              end else
               begin
                Timer2.Enabled := false;
                PtOld := Pt;
               end;

        {    }
            if not MsFlag then
              begin
                Mouse_Event(MOUSEEVENTF_LEFTDOWN, 0, 0, 0, 0);
                Beep('$01');
                PtOld := Pt;
                MsFlag := true;
              end;
          end;
      end;
  end;

  if USBtr.PacketDataRX[0]=$A1 then
    begin
      if RegisterDone = true then
        begin
          OutData := '04A1'+ inttohex(USBtr.PacketDataRX[1],2)
          + inttohex (USBtr.PacketDataRX[2],2);
          WM_CopyDataTX(4);
        end;

      if USBtr.PacketDataRX[1]=$84 then
        begin
         if (USBtr.PacketDataRX[2]=$02)and(mapEn) then
           begin
            KeyboardEvent(mapStat, mapVkey);
            Beep('$01');
           end;
         if (USBtr.PacketDataRX[2]=$04)and(destEn) then
           begin
            KeyboardEvent(destStat, destVkey);
            Beep('$01');
           end;
         if (USBtr.PacketDataRX[2]=$01)and(menuEn) then
           begin
            KeyboardEvent(menuStat, menuVkey);
            Beep('$01');
           end;
        end;
      if USBtr.PacketDataRX[1]=$80 then
        begin
         if (USBtr.PacketDataRX[2]=$01)and(maintEn) then
          begin
            KeyboardEvent(maintStat, maintVkey);
            Beep('$01');
          end;
         if (USBtr.PacketDataRX[2]=$08)and(calendEn) then
          begin
            KeyboardEvent(calendStat, calendVkey);
            Beep('$01');
          end;
         if (USBtr.PacketDataRX[2]=$40)and(langEn) then
          begin
            KeyboardEvent(langStat, langVkey);
            Beep('$01');
          end;
        end;

      if USBtr.PacketDataRX[1]=$40 then
        begin
         if (USBtr.PacketDataRX[2]=$94)and(FFEn) then
          begin
            KeyboardEvent(FFStat, FFVkey);
 //           Beep('$01');
          end;
         if (USBtr.PacketDataRX[2]=$95)and(RREn) then
          begin
            KeyboardEvent(RRStat, RRVkey);
 //           Beep('$01');
          end;
         if (USBtr.PacketDataRX[2]=$98)and(FSEn) then
          begin
            KeyboardEvent(FSStat, FSVkey);
//            KeyboardEventDown(FSStat, FSVkey);
//            FSPress := true;
//            Beep('$01');
          end;
         if (USBtr.PacketDataRX[2]=$99)and(RSEn) then
          begin
            KeyboardEvent(RSStat, RSVkey);
//            KeyboardEventDown(RSStat, RSVkey);
//            RSPress := true;
 //           Beep('$01');
          end;
        end;
    end;

  if USBtr.PacketDataRX[0]=$A3 then
    begin
      if RegisterDone = true then
        begin
          OutData := '03A3'+ inttohex(USBtr.PacketDataRX[1],2);
          WM_CopyDataTX(3);
        end;
    end;

  if USBtr.PacketDataRX[0]=$A4 then
    begin
      if RegisterDone = true then
        begin
          OutData := '03A4'+ inttohex(USBtr.PacketDataRX[1],2);
          WM_CopyDataTX(3);
        end;
    end;

  if USBtr.PacketDataRX[0]=$A8 then
    begin
      if RegisterDone = true then
        begin
          OutData := '03A8'+ inttohex(USBtr.PacketDataRX[1],2);
          WM_CopyDataTX(3);
        end;
    end;

  if USBtr.PacketDataRX[0]=$A9 then
    begin
      if RegisterDone = true then
        begin
          OutData := '08A9'+ inttohex(USBtr.PacketDataRX[1],2)+
          inttohex(USBtr.PacketDataRX[2],2)+inttohex(USBtr.PacketDataRX[3],2)+
          inttohex(USBtr.PacketDataRX[4],2)+inttohex(USBtr.PacketDataRX[5],2)+
          inttohex(USBtr.PacketDataRX[6],2);
          WM_CopyDataTX(8);
        end;
    end;

  if USBtr.PacketDataRX[0]=$AA then
    begin
      if RegisterDone = true then
        begin
          OutData := '08AA'+ inttohex(USBtr.PacketDataRX[1],2)+
          inttohex(USBtr.PacketDataRX[2],2)+inttohex(USBtr.PacketDataRX[3],2)+
          inttohex(USBtr.PacketDataRX[4],2)+inttohex(USBtr.PacketDataRX[5],2)+
          inttohex(USBtr.PacketDataRX[6],2);
          WM_CopyDataTX(8);
        end;
    end;

  if USBtr.PacketDataRX[0]=$AF then
    begin
       Label14.Caption := inttostr(USBtr.PacketDataRX[1])
       + '.' + inttostr(USBtr.PacketDataRX[2]);
 //      Timer1.Enabled := false;
       AVC_LAN.IconIndex := 0;
      if RegisterDone = true then
        begin
          OutData := '04AF'+ inttohex(USBtr.PacketDataRX[1],2)
          + inttohex (USBtr.PacketDataRX[2],2);
          WM_CopyDataTX(4);
        end;
    end;


end;



procedure TForm1.N1Click(Sender: TObject);
begin
  ClosedEnable := false;
 Form1.Show;
end;



procedure TForm1.AVC_LANStartup(Sender: TObject;
  var ShowMainForm: Boolean);
begin
 ShowMainForm := false;
end;

procedure TForm1.KeyboardEvent(VKey, VKey1: Byte);
 // var
 //   KeyboardMsg: TMsg;
  begin
    if VKey and vkControl = vkControl then keybd_event(vk_Control, 0, 0, 0);
    if VKey and vkShift = vkShift   then keybd_event(vk_Shift, 0, 0, 0);
    if VKey and vkMenu = vkMenu   then keybd_event(vk_Menu, 0, 0, 0);

    keybd_event(VKey1, 0, 0, 0);
    keybd_event(VKey1, 0, KEYEVENTF_KEYUP, 0);

    if VKey and vkControl = vkControl then keybd_event(vk_Control, 0, KEYEVENTF_KEYUP, 0);
    if VKey and vkShift = vkShift   then keybd_event(vk_Shift, 0, KEYEVENTF_KEYUP, 0);
    if VKey and vkMenu = vkMenu   then keybd_event(vk_Menu, 0, KEYEVENTF_KEYUP, 0);


  end;

procedure TForm1.KeyboardEventDown(VKey, VKey1: Byte);
 // var
 //   KeyboardMsg: TMsg;
  begin
    if VKey and vkControl = vkControl then keybd_event(vk_Control, 0, 0, 0);
    if VKey and vkShift = vkShift   then keybd_event(vk_Shift, 0, 0, 0);
    if VKey and vkMenu = vkMenu   then keybd_event(vk_Menu, 0, 0, 0);

    keybd_event(VKey1, 0, 0, 0);
  end;

procedure TForm1.KeyboardEventUp();
var
VKey1,VKey : byte;
begin
    if FSPress then
      begin
        VKey1 := FSVKey;
        VKey :=  FSStat;
      end;
    if RSPress then
      begin
        VKey1 := RSVKey;
        VKey :=  RSStat;
      end;
    if (not RSPress) and (not FSPress) then exit;

    FSPress := false;
    RSPress := false;



    keybd_event(VKey1, 0, KEYEVENTF_KEYUP, 0);

    if VKey and vkControl = vkControl then keybd_event(vk_Control, 0, KEYEVENTF_KEYUP, 0);
    if VKey and vkShift = vkShift   then keybd_event(vk_Shift, 0, KEYEVENTF_KEYUP, 0);
    if VKey and vkMenu = vkMenu   then keybd_event(vk_Menu, 0, KEYEVENTF_KEYUP, 0);

end;


procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);

begin
    if (Key = $10)or (Key = $11)or (Key = $12) then exit;
    if Key > 128 then Key := Key-128;
    if VkeyToStr(Key) = '' then exit;

    if Edit1.Focused then
      begin
        mapStat := ShiftStat(Shift);
        mapVkey := Key;
        Edit1.Text := StatToStr(mapStat) + VkeyToStr(Key);
      end;

    if Edit2.Focused then
      begin
        destStat := ShiftStat(Shift);
        destVkey := Key;
        Edit2.Text := StatToStr(destStat) + VkeyToStr(Key);
      end;

    if Edit3.Focused then
      begin
        menuStat := ShiftStat(Shift);
        menuVkey := Key;
        Edit3.Text := StatToStr(menuStat) + VkeyToStr(Key);
      end;

    if Edit4.Focused then
      begin
        maintStat := ShiftStat(Shift);
        maintVkey := Key;
        Edit4.Text := StatToStr(maintStat) + VkeyToStr(Key);
      end;

    if Edit5.Focused then
      begin
        calendStat := ShiftStat(Shift);
        calendVkey := Key;
        Edit5.Text := StatToStr(calendStat) + VkeyToStr(Key);
      end;

    if Edit6.Focused then
      begin
        langStat := ShiftStat(Shift);
        langVkey := Key;
        Edit6.Text := StatToStr(langStat) + VkeyToStr(Key);
      end;

    if Edit7.Focused then
      begin
        FFStat := ShiftStat(Shift);
        FFVkey := Key;
        Edit7.Text := StatToStr(FFStat) + VkeyToStr(Key);
      end;

    if Edit8.Focused then
      begin
        RRStat := ShiftStat(Shift);
        RRVkey := Key;
        Edit8.Text := StatToStr(RRStat) + VkeyToStr(Key);
      end;

    if Edit9.Focused then
      begin
        FSStat := ShiftStat(Shift);
        FSVkey := Key;
        Edit9.Text := StatToStr(FSStat) + VkeyToStr(Key);
      end;

    if Edit10.Focused then
      begin
        RSStat := ShiftStat(Shift);
        RSVkey := Key;
        Edit10.Text := StatToStr(RSStat) + VkeyToStr(Key);
      end;

end;

Function TForm1.VkeyToStr(key : word):string;
begin
  case key of
  $25 : result := 'Left';
  $26 : result := 'Up';
  $27 : result := 'Right';
  $28 : result := 'Down';
  $70 : result := 'F1';
  $71 : result := 'F2';
  $72 : result := 'F3';
  $73 : result := 'F4';
  $74 : result := 'F5';
  $75 : result := 'F6';
  $76 : result := 'F7';
  $77 : result := 'F8';
  $78 : result := 'F9';
  $79 : result := 'F10';
  $7A : result := 'F11';
  $7B : result := 'F12';
  $1B : result := 'Esc';

  else 
   begin
     if (key > $2F) and (key < $60) then
      result := Char(key) else result := '';
        
   end;
  end;

end;




procedure TForm1.Beep(N : string);
begin
  USBtr.LenTX := 2;
  USBtr.PacketDataTX[0]:= $F0;
  USBtr.PacketDataTX[1]:= strtoint (N);
  USBtr.TXFlag := true;
end;







procedure TForm1.N3Click(Sender: TObject);
begin
//  ClosedEnable := true;
  Form1.Close;
end;


procedure TForm1.Timer1Timer(Sender: TObject);
begin
  if USBtr.AdaptEnable then
    begin
      AVC_LAN.IconIndex := 1;
      USBtr.LenTX := 2;
      USBtr.PacketDataTX[0]:= $F5;
      USBtr.PacketDataTX[1]:= $01;
      USBtr.TXFlag := true;
    end else AVC_LAN.IconIndex := 2;

end;




procedure TForm1.Button1Click(Sender: TObject);
begin
  mapEn := CheckBox1.Checked;
  destEn := CheckBox2.Checked;
  menuEn := CheckBox3.Checked;
  maintEn := CheckBox4.Checked;
  calendEn := CheckBox5.Checked;
  langEn := CheckBox6.Checked;

  FFEn := CheckBox8.Checked;
  RREn := CheckBox9.Checked;
  FSEn := CheckBox10.Checked;
  RSEn := CheckBox11.Checked;

  SaveSetting(SetupKey);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  LoadSetting(SetupKey);

  CheckBox1.Checked := mapEn;
  CheckBox2.Checked := destEn;
  CheckBox3.Checked := menuEn;
  CheckBox4.Checked := maintEn;
  CheckBox5.Checked := calendEn;
  CheckBox6.Checked := langEn;

  CheckBox8.Checked := FFEn;
  CheckBox9.Checked := RREn;
  CheckBox10.Checked := FSEn;
  CheckBox11.Checked := RSEn;

  Edit1.Text := StatToStr(mapStat)+' '+ VkeyToStr(mapVkey);
  Edit2.Text := StatToStr(destStat)+' '+ VkeyToStr(destVkey);
  Edit3.Text := StatToStr(menuStat)+' '+ VkeyToStr(menuVkey);
  Edit4.Text := StatToStr(maintStat)+' '+ VkeyToStr(maintVkey);
  Edit5.Text := StatToStr(calendStat)+' '+ VkeyToStr(calendVkey);
  Edit6.Text := StatToStr(langStat)+' '+ VkeyToStr(langVkey);

  Edit7.Text := StatToStr(FFStat)+' '+ VkeyToStr(FFVkey);
  Edit8.Text := StatToStr(RRStat)+' '+ VkeyToStr(RRVkey);
  Edit9.Text := StatToStr(FSStat)+' '+ VkeyToStr(FSVkey);
  Edit10.Text := StatToStr(RSStat)+' '+ VkeyToStr(RSVkey);

  Edit1.Enabled := CheckBox1.Checked ;
  Edit2.Enabled := CheckBox2.Checked ;
  Edit3.Enabled := CheckBox3.Checked ;
  Edit4.Enabled := CheckBox4.Checked ;
  Edit5.Enabled := CheckBox5.Checked ;
  Edit6.Enabled := CheckBox6.Checked ;

  Edit7.Enabled := CheckBox8.Checked ;
  Edit8.Enabled := CheckBox9.Checked ;
  Edit9.Enabled := CheckBox10.Checked ;
  Edit10.Enabled := CheckBox11.Checked ;

end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
  MonitorCount := ComboBox1.ItemIndex;

end;

procedure TForm1.Button3Click(Sender: TObject);
begin
Form4.Show;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
 Edit1.Enabled := CheckBox1.Checked ;
 mapEn := CheckBox1.Checked ;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
 Edit2.Enabled := CheckBox2.Checked ;
 destEn := CheckBox2.Checked ;
end;

procedure TForm1.CheckBox3Click(Sender: TObject);
begin
 Edit3.Enabled := CheckBox3.Checked ;
 menuEn := CheckBox3.Checked ;
end;

procedure TForm1.CheckBox4Click(Sender: TObject);
begin
 Edit4.Enabled := CheckBox4.Checked ;
 maintEn := CheckBox4.Checked ;
end;

procedure TForm1.CheckBox5Click(Sender: TObject);
begin
 Edit5.Enabled := CheckBox5.Checked ;
 calendEn := CheckBox5.Checked ;
end;

procedure TForm1.CheckBox6Click(Sender: TObject);
begin
 Edit6.Enabled := CheckBox6.Checked ;
 langEn := CheckBox6.Checked ;
end;

procedure TForm1.ScrollBar1Change(Sender: TObject);
begin
  Label11.Caption := inttostr(ScrollBar1.Position);
  RBTime := ScrollBar1.Position;
  Timer2.Interval := RBTime*1000;
end;

procedure TForm1.CheckBox7Click(Sender: TObject);
begin
  RbuttonEna := CheckBox7.Checked;
  Label8.Enabled := CheckBox7.Checked;
  Label11.Enabled := CheckBox7.Checked;
  Label12.Enabled := CheckBox7.Checked;
  ScrollBar1.Enabled := CheckBox7.Checked;
end;

procedure TForm1.Timer2Timer(Sender: TObject);
begin
  Timer2.Enabled := false;
  Beep('$02');
  Mouse_Event(MOUSEEVENTF_LEFTUP, 0, 0, 0, 0);
  Mouse_Event(MOUSEEVENTF_RIGHTDOWN, 0, 0, 0, 0);
  RIGHTDOWN := true;
  Mouse_Event(MOUSEEVENTF_RIGHTUP, 0, 0, 0, 0);
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
   SaveSetting(SetupKey);
   AVC_LAN.HideMainForm;
end;

procedure TForm1.CheckBox8Click(Sender: TObject);
begin
 Edit7.Enabled := CheckBox8.Checked ;
 FFEn := CheckBox8.Checked ;
end;

procedure TForm1.CheckBox9Click(Sender: TObject);
begin
 Edit8.Enabled := CheckBox9.Checked ;
 RREn := CheckBox9.Checked ;
end;

procedure TForm1.CheckBox10Click(Sender: TObject);
begin
 Edit9.Enabled := CheckBox10.Checked ;
 FSEn := CheckBox10.Checked ;
end;

procedure TForm1.CheckBox11Click(Sender: TObject);
begin
 Edit10.Enabled := CheckBox11.Checked ;
 RSEn := CheckBox11.Checked ;
end;

procedure TForm1.Timer3Timer(Sender: TObject);
begin
   if (not EnaDone) and USBtr.AdaptEnable then
    begin
      EnaDone := true;
      if RegisterDone = true then
        begin
          OutData := '03A501';
          WM_CopyDataTX(3);
        end;
    end;

   if EnaDone and (not USBtr.AdaptEnable) then
    begin
      EnaDone := false;
      if RegisterDone = true then
        begin
          OutData := '03A500';
          WM_CopyDataTX(3);
        end;
    end;
end;

end.
